/*-----------------------------------------
  ժOlWDHT11ACj@qɶŪŷëסA
  ܦbTM1637ҲդCqܾW

   2024/02/07
-------------------------------------------*/
#include <reg51.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <intrins.h>

//Define port
sbit clk = P1^3;
sbit dio = P1^1;
 
const unsigned char code seg_data[18] =    //TM1637 Fonts
{
     0x3F, // 0
     0x06, // 1
     0x5B, // 2
     0x4F, // 3
     0x66, // 4
     0x6D, // 5
     0x7D, // 6
     0x07, // 7
     0x7F, // 8
     0x6F, // 9 
     0x00, // none  10
     0x03, // :     11
     0x04, // .     12
     0x79, // E     13
     0x50, // r     14
     0x39, // C     15
     0x76, // H     16
     0x02  // .     17   _UI
 }; 
 
//========= TM1637 Functions ==============================
void delay1ms()
{
    TMOD = 0x01;    // Timer0 mode1
    TH0 = 0xFC; 	 //initial value for 1ms
    TL0 = 0x66;
    TR0 = 1;      // timer start
    while(TF0==0);  // check overflow condition
    TR0 = 0;     // Stop Timer
    TF0 = 0;    // Clear flag
}

void delay_ms(int n)
{
    int i;
    for(i=0; i<=n; i++)
	     delay1ms();
}
//-------------------------------------------------------
void Delay_us (unsigned int i) // n us delay
{
   for (; i> 0; i--)
     nop_ ();
}
//-------------------------------------------------------
void I2CStart (void) // 1637 start
{
   clk = 1;
   dio = 1;
   Delay_us (2);
   dio = 0;
}
//-------------------------------------------------------
void I2Cask (void) // 1637 Answer
{
   clk = 0;
   // After the falling edge of the eighth clock delay 5us, 
   // ACK signals the beginning of judgment.
   Delay_us (5); 
   while (dio);
   clk = 1;
   Delay_us (2);
   clk = 0;
}
//-------------------------------------------------------
void I2CStop (void) // 1637 Stop
{
   clk = 0;
   Delay_us (2);
   dio = 0;
   Delay_us (2);
   clk = 1;
   Delay_us (2);
   dio = 1;
}
//-------------------------------------------------------
void I2CWrByte (unsigned char oneByte) // write a byte
{
   unsigned char i;
   for (i = 0; i <8; i++)
   {
      clk = 0;
      if (oneByte & 0x01)   // low front
        {dio = 1;}
      else 
        {dio = 0;}
      Delay_us (3);
      oneByte = oneByte >> 1;
      clk = 1;
      Delay_us (3);
   }
}
//-------------------------------------------------------
void DisplayNum(int num[5]) // Write display register
{
   unsigned char i; 
   I2CStart();
   I2CWrByte(0x40); //40H address is automatically incremented by 1 mode, 44H fixed address mode
   I2Cask();
   I2CStop();
   I2CStart();
   I2CWrByte(0xC0); // Set the address, 0xC0 is first
   I2Cask();
   for(i=0;i<5;i++) // Addresses from Canada, do not always write address
   {
      if(i == 2)
        I2CWrByte(seg_data[num[i]] | 0x80); // Send data with point
      else
        I2CWrByte(seg_data[num[i]]); // Send data
      I2Cask();
   }
   I2Cask();
   I2CStop();
   I2CStart();
   I2CWrByte(0x8f); // Open display, maximum brightness
   I2Cask();
   I2CStop();
}

//========= DHT11 Functions =======================================
sbit DHT11 = P1^0;		// Connect DHT11 output Pin to P1.0 Pin 
int I_RH, D_RH, I_Temp, D_Temp, CheckSum; 

void timer_delay20ms()		// Timer0 delay function 
{
	TMOD = 0x01;
	TH0 = 0xB8;		// Load higher 8-bit in TH0 
	TL0 = 0x0C;		// Load lower 8-bit in TL0 
	TR0 = 1;		// Start timer0 
	while(TF0 == 0);	// Wait until timer0 flag set 
	TR0 = 0;		// Stop timer0 
	TF0 = 0;		// Clear timer0 flag 
}
//-------------------------------------------------------
void timer_delay30us()		// Timer0 delay function 
{
	TMOD = 0x01;		// Timer0 mode1 (16-bit timer mode) 
	TH0 = 0xFF;		// Load higher 8-bit in TH0 
	TL0 = 0xF1;		// Load lower 8-bit in TL0 
	TR0 = 1;		// Start timer0 
	while(TF0 == 0);	// Wait until timer0 flag set 
	TR0 = 0;		// Stop timer0 
	TF0 = 0;		// Clear timer0 flag 
}
//-------------------------------------------------------
void Request()			// Microcontroller send request 
{
	DHT11 = 0;		// set to low pin 
	timer_delay20ms();	// wait for 20ms 
	DHT11 = 1;		// set to high pin 
}
//-------------------------------------------------------
void Response()			// Receive response from DHT11 
{
	while(DHT11 == 1);
	while(DHT11 == 0);
	while(DHT11 == 1);
}
//-------------------------------------------------------
int Receive_data()		// Receive data 
{
	int q,c = 0;	
	for (q=0; q<8; q++)
	{
		while(DHT11 == 0);// check received bit 0 or 1 
		timer_delay30us();
		if(DHT11 == 1)	// If high pulse is greater than 30ms 
		  c = (c << 1) | (0x01);// Then its logic HIGH 
		else		// otherwise its logic LOW 
		  c = (c << 1);
		while(DHT11 == 1);
	}
	return c;
}

//=========================================================
void main()
{ 
    int i, num[5];  //num[0]O:, num[1]O̥, ̦k
    for(i=0; i<5; i++)
        num[i] = 10;
    DisplayNum(num);
  
    while(1)
    {		
        Request();	// send start pulse 
        Response();	// receive response 
        
        I_RH = Receive_data();	// store first eight bit in I_RH 
        D_RH = Receive_data();	// store next eight bit in D_RH 
        I_Temp = Receive_data();	// store next eight bit in I_Temp 
        D_Temp = Receive_data();	// store next eight bit in D_Temp 
        CheckSum = Receive_data();// store next eight bit in CheckSum 

        if ((I_RH + D_RH + I_Temp + D_Temp) != CheckSum)
        {
            //When Error
            num[1] = 13;
            num[2] = 14;
            num[3] = 14;
            DisplayNum(num);
        }
        else
        {
            num[0] = 17;
            num[1] = (int)(I_Temp / 10);
            num[2] = I_Temp % 10;
            num[3] = (int)(D_Temp / 10);
            num[4] = 15;  //C
            DisplayNum(num);
            delay_ms(5000);
            num[0] = 17;
            num[1] = (int)(I_RH / 10);
            num[2] = I_RH % 10;
            num[3] = (int)(D_RH / 10);
            num[4] = 16;  //H
            DisplayNum(num);
            delay_ms(5000);   
        }  
    }	
}